using System;

namespace IlijaDoncic
{
    class IlijaDoncic
    {
        static void Main()
        {
            int T = int.Parse(Console.ReadLine()!);
            for (int t = 0; t < T; t++)
            {
                int N = int.Parse(Console.ReadLine()!);
                int[] array = Array.ConvertAll(Console.ReadLine()!.Split(), int.Parse);
                int x = 0;
                int[] result = GetMaximizedXORArray(array, ref x);
                Console.WriteLine(x);
                PrintArray(result);
            }
        }

        static int[] GetMaximizedXORArray(int[] array, ref int x)
        {
            int[] sortedArray = (int[])array.Clone();
            Array.Sort(sortedArray, (a, b) => b.CompareTo(a));

            int currentIndex = 0;

            // Swap elements to ensure no repeated instances of matching numbers
            while (currentIndex < array.Length - 1 && sortedArray[currentIndex] == array[currentIndex])
            {
                for (int i = currentIndex + 1; i < array.Length - 1; i++)
                {
                    if (sortedArray[currentIndex] != sortedArray[i])
                    {
                        Swap(ref sortedArray[currentIndex], ref sortedArray[i]);
                        break;
                    }

                }
                currentIndex++;
            }
            for (int i = 0; i < array.Length; i++)
            {
                x += sortedArray[i] + array[i];
            }

            return sortedArray;
        }

        static void Swap(ref int a, ref int b)
        {
            int temp = a;
            a = b;
            b = temp;
        }

        static void PrintArray(int[] arr)
        {
            foreach (var item in arr)
            {
                Console.Write(item + " ");
            }
            Console.WriteLine();
        }
    }
}